using System;
using System.Collections.Generic;
using System.Linq;
using Yukar.Engine;

namespace Bakin
{
    public class HideMessage : BakinObject
    {
        bool recentVisibleMessage = false;
        bool recentVisibleDialogue = false;
        bool recentVisibleChoice = false;
        private Dictionary<Guid, bool> messageVisibility;
        private Dictionary<Guid, bool> dialogueVisibility;

        [BakinFunction(Description = "Temporarily hide the message window.\nメッセージウィンドウを一時的に非表示にします。")]
        public void Hide()
        {
            var menu = mapScene.menuWindow as LayoutMenuController;
            if (menu == null)
                return;

            recentVisibleMessage = menu.isVisibleMessage();
            recentVisibleDialogue = menu.isVisibleDialogue();

            if (recentVisibleMessage)
            {
                messageVisibility = menu.message.LayoutDrawer.ParseNodes().ToDictionary(x => x.MenuItem.guid, x => x.IsVisible);
                menu.message.Hide(true);
                menu.message.Lock();
            }

            if (recentVisibleDialogue)
            {
                dialogueVisibility = menu.dialogue.LayoutDrawer.ParseNodes().ToDictionary(x => x.MenuItem.guid, x => x.IsVisible);
                menu.dialogue.Hide(true);
                menu.dialogue.Lock();
            }
        }

        [BakinFunction(Description = "Redisplay temporarily hidden message windows.\n一時的に非表示にしたメッセージウィンドウを再表示します。")]
        public void Show()
        {
            var menu = mapScene.menuWindow as LayoutMenuController;
            if (menu == null)
                return;

            if (recentVisibleMessage)
            {
                menu.message.Show();
                menu.message.LayoutDrawer.ParseNodes().ForEach(x => x.IsVisible = messageVisibility[x.MenuItem.guid]);
                menu.message.UnLock();
            }

            if (recentVisibleDialogue)
            {
                menu.dialogue.Show();
                menu.dialogue.LayoutDrawer.ParseNodes().ForEach(x => x.IsVisible = dialogueVisibility[x.MenuItem.guid]);
                menu.dialogue.UnLock();
            }
        }

        [BakinFunction(Description = "Temporarily lock the message window.\nメッセージウィンドウ、会話ウィンドウ、選択肢ウィンドウを一時的にロックします。")]
        public void WindowLock()
        {
            var menu = mapScene.menuWindow as LayoutMenuController;
            if (menu == null)
                return;

            recentVisibleMessage = menu.isVisibleMessage();
            recentVisibleDialogue = menu.isVisibleDialogue();
            recentVisibleChoice = menu.isVisibleChoices();

            if (recentVisibleMessage)
            {
                menu.message.Lock();
            }

            if (recentVisibleDialogue)
            {
                menu.dialogue.Lock();
            }

            if (recentVisibleChoice)
            {
                menu.choices.Lock();
            }
        }

        [BakinFunction(Description = "Unlock temporarily locked message windows.\n一時的にロックしたメッセージウィンドウをアンロックします。")]
        public void WindowUnlock()
        {
            var menu = mapScene.menuWindow as LayoutMenuController;
            if (menu == null)
                return;

            if (recentVisibleMessage)
            {
                menu.message.UnLock();
            }

            if (recentVisibleDialogue)
            {
                menu.dialogue.UnLock();
            }

            if (recentVisibleChoice)
            {
                menu.choices.UnLock();
            }
        }
    }
}
