using System;
using Yukar.Engine;
using Yukar.Common.Rom;

namespace Bakin
{
    public class CastFinderScript : BakinObject
    {
        [BakinFunction(Description= "キャストを図鑑に登録します。\nキャストイベントに割り当ててFindCastを呼び出すだけで図鑑に登録されます。")]
        public void FindCast()
        {
            // [BakinFunction] を付与したメソッドはイベントパネル「C#プログラムの呼び出し」からコールできます。bool/int/float/string の戻り値および引数を一つまで取ることができます。
            // また、引数専用で Microsoft.Xna.Framework.Vector2/Vector3/Vector4/Color を利用して複数のfloat値を受け取ることができます。
            // One of the methods with [BakinFunction] can be called from the event panel "Calling C# Programs".  Up to one bool/int/float/string return value and parameter can be used.
            // Also, it can receive multiple float values using Microsoft.Xna.Framework.Vector2/Vector3/Vector4/Color for parameter only.

            Cast tc = mapChr.rom.Cast;
            if (tc == null) {
                GameMain.PushLog(DebugDialog.LogEntry.LogType.EVENT, "CastFinderScript : ", "Castが見つかりません。キャストイベントに割り当てられているかどうか確認してください。");
                return;
            }

            if (!GameMain.instance.data.party.FoundCasts.Contains(tc.guId))
            {
                GameMain.instance.data.party.FoundCasts.Add(tc.guId);
            }
        }
    }
}